/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.report.urgentpath.AbstractWaiting;
import cz.insophy.inplan.report.urgentpath.WaitingVisitor;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nonnull;

public class CapacityWaiting
extends AbstractWaiting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String capability;
    private final String capabilityDesc;
    private final long resourceRequirement;
    private final long normtimeProduction;
    private final long normtimeOfflines;
    private final long normtimeUnused;

    public CapacityWaiting(GeneralizedOrderRequest gor, GeneralizedActionRequest gar, @Nonnull String capability, @Nonnull String capabilityDesc, long resourceRequirement, long from, long length, long normtimeProduction, long normtimeOfflines, long normtimeUnused) {
        super(gor, gar, from, length);
        this.capability = Preconditions.checkNotNull(capability);
        this.capabilityDesc = Preconditions.checkNotNull(capabilityDesc);
        this.resourceRequirement = resourceRequirement;
        this.normtimeProduction = normtimeProduction;
        this.normtimeOfflines = normtimeOfflines;
        this.normtimeUnused = normtimeUnused;
    }

    @Nonnull
    public String getCapability() {
        return this.capability;
    }

    @Nonnull
    public String getCapabilityDesc() {
        return this.capabilityDesc;
    }

    public long getResourceRequirement() {
        return this.resourceRequirement;
    }

    public long getNormtimeProduction() {
        return this.normtimeProduction;
    }

    public long getNormtimeOfflines() {
        return this.normtimeOfflines;
    }

    public long getNormtimeUnused() {
        return this.normtimeUnused;
    }

    @Override
    public void accept(WaitingVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "CapacityWaiting{gor=" + this.gor.getId() + ", gar=" + this.gar.getAction() + ", capability='" + this.capability + "', resourceRequirement=" + (double)this.resourceRequirement / 1000.0 / 3600.0 + " h, from=" + new Date(this.from) + ", length=" + (double)this.length / 1000.0 / 3600.0 + " h, normtimeProduction=" + (double)this.normtimeProduction / 1000.0 / 3600.0 + " h, normtimeOfflines=" + (double)this.normtimeOfflines / 1000.0 / 3600.0 + " h, normtimeUnused=" + (double)this.normtimeUnused / 1000.0 / 3600.0 + " h}";
    }
}

